/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.ComponentModel;
using System.Drawing; // For ToolboxBitmap
using System.Drawing.Design; // for type editor

using Borland.Eco.Subscription;
using Borland.Eco.Handles;
using Borland.Eco.UmlRt;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Persistence;
using Borland.Eco.Services;
using Borland.Eco.Ocl.Support;
using Borland.Eco.Exceptions;
using Borland.Eco.Globalization;
using Borland.Eco.Interfaces;

namespace Borland.Eco.Handles
{
	[ToolboxBitmap(typeof(OclPSHandle), "Borland.Eco.Handles.OclPSHandle.bmp")]
	[ToolboxItem(true)]
	public sealed class OclPSHandle: RootedHandle, IHasEditableExpression
	{
		//IHasEditableExpression
		IStaticContext IHasEditableExpression.StaticContext
		{
			get { return EffectiveRootStaticContext; }
		}

		ExpressionKind  IHasEditableExpression.ExpressionKind
		{
			get { return ExpressionKind.OclPs; }
		}

		protected override void DeriveAndSubscribe(ISubscriber valueChangeSubscriber, ISubscriber resubscribeSubscriber)
		{
		}

		protected override bool RefersToComponent(object component)
		{
			bool result = base.RefersToComponent(component);
			if (!result && (component != null))
			{
				result = (component == Variables);
			}
			return result;
		}

		protected sealed override IClassifier GetStaticUmlType()
		{
			if (EffectiveRootStaticContext.OclTypeService != null)
				try
				{
					return EffectiveRootStaticContext.OclTypeService.ExpressionType(Expression, EffectiveRootStaticContext.StaticUmlType, false, EffectiveVariables());
				}
				catch
				{
					// Ignore errors, just return null type.
				}
				return null;
		}

		private string m_Expression = "";

		/// <summary>
		/// The OCL expression to be used when deriving the value of the handle.
		/// The Element property is set to the value obtained by applying this
		/// property to the RootHandle.Element.
		/// </summary>
		[LocalizableCategory(typeof(HandlesStringRes), "sCategoryOCL")]
		[LocalizableDescription(typeof(HandlesStringRes), "sPropertyExpression")]
		[Editor("Borland.Eco.Handles.Design.OclPsEditorWakeup, Borland.Eco.Handles.Design", typeof(UITypeEditor))]
		[DefaultValue("")]
		public string Expression
		{
			get { return m_Expression; }
			set
			{
				if (value != m_Expression)
				{
					m_Expression = value;
					MarkSubscriptionOutOfDate();
					StaticContextChanged();
				}
			}
		}

		private int m_MaxAnswers = -1;
		[LocalizableCategory(typeof(InterfacesStringRes), "sCategoryPersistenceTuning")]
		[LocalizableDescription(typeof(HandlesStringRes), "sPropertyMaxAnswers")]
		[DefaultValue(-1)]
		public int MaxAnswers { get { return m_MaxAnswers; } set { m_MaxAnswers = value; } }
		private int m_Offset;
		[LocalizableCategory(typeof(InterfacesStringRes), "sCategoryPersistenceTuning")]
		[LocalizableDescription(typeof(HandlesStringRes), "sPropertyOffset")]
		[DefaultValue(0)]
		public int Offset { get { return m_Offset; } set { m_Offset = value; } }

		/// <summary>
		/// Converts the Expression to SQL and evaluates it directly in the DB.
		/// This yields a snapshot of the state of the DB.
		/// </summary>
		public void Execute()
		{
			IElement rootValue = EffectiveRootValue();
			IOclPsService oclPsService = (IOclPsService)GetEcoService(typeof(IOclPsService));
			InternalElement = oclPsService.Execute(rootValue, EffectiveVariables(), Expression, MaxAnswers, Offset);
			ElementChanged();
		}
	}
}
